/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class PlayerModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private static final String EAR = "ear";
    private static final String CLOAK = "cloak";
    private static final String LEFT_SLEEVE = "left_sleeve";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_PANTS = "left_pants";
    private static final String RIGHT_PANTS = "right_pants";
    private final List<ModelPart> parts;
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;
    private final ModelPart cloak;
    private final ModelPart ear;
    private final boolean slim;

    public PlayerModel(ModelPart p_170821_, boolean p_170822_) {
        super(p_170821_, RenderType::entityTranslucent);
        this.slim = p_170822_;
        this.ear = p_170821_.getChild(EAR);
        this.cloak = p_170821_.getChild(CLOAK);
        this.leftSleeve = p_170821_.getChild(LEFT_SLEEVE);
        this.rightSleeve = p_170821_.getChild(RIGHT_SLEEVE);
        this.leftPants = p_170821_.getChild(LEFT_PANTS);
        this.rightPants = p_170821_.getChild(RIGHT_PANTS);
        this.jacket = p_170821_.getChild("jacket");
        this.parts = (List)p_170821_.getAllParts().filter(p_170824_ -> !p_170824_.isEmpty()).collect(ImmutableList.toImmutableList());
    }

    public static MeshDefinition createMesh(CubeDeformation p_170826_, boolean p_170827_) {
        MeshDefinition $$2 = HumanoidModel.createMesh(p_170826_, 0.0f);
        PartDefinition $$3 = $$2.getRoot();
        $$3.addOrReplaceChild(EAR, CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, -6.0f, -1.0f, 6.0f, 6.0f, 1.0f, p_170826_), PartPose.ZERO);
        $$3.addOrReplaceChild(CLOAK, CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, p_170826_, 1.0f, 0.5f), PartPose.offset(0.0f, 0.0f, 0.0f));
        float $$4 = 0.25f;
        if (p_170827_) {
            $$3.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(5.0f, 2.5f, 0.0f));
            $$3.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(-5.0f, 2.5f, 0.0f));
            $$3.addOrReplaceChild(LEFT_SLEEVE, CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset(5.0f, 2.5f, 0.0f));
            $$3.addOrReplaceChild(RIGHT_SLEEVE, CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset(-5.0f, 2.5f, 0.0f));
        } else {
            $$3.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(5.0f, 2.0f, 0.0f));
            $$3.addOrReplaceChild(LEFT_SLEEVE, CubeListBuilder.create().texOffs(48, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset(5.0f, 2.0f, 0.0f));
            $$3.addOrReplaceChild(RIGHT_SLEEVE, CubeListBuilder.create().texOffs(40, 32).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset(-5.0f, 2.0f, 0.0f));
        }
        $$3.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_), PartPose.offset(1.9f, 12.0f, 0.0f));
        $$3.addOrReplaceChild(LEFT_PANTS, CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset(1.9f, 12.0f, 0.0f));
        $$3.addOrReplaceChild(RIGHT_PANTS, CubeListBuilder.create().texOffs(0, 32).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.offset(-1.9f, 12.0f, 0.0f));
        $$3.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170826_.extend(0.25f)), PartPose.ZERO);
        return $$2;
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat(super.bodyParts(), (Iterable)ImmutableList.of((Object)this.leftPants, (Object)this.rightPants, (Object)this.leftSleeve, (Object)this.rightSleeve, (Object)this.jacket));
    }

    public void renderEars(PoseStack p_103402_, VertexConsumer p_103403_, int p_103404_, int p_103405_) {
        this.ear.copyFrom(this.head);
        this.ear.x = 0.0f;
        this.ear.y = 0.0f;
        this.ear.render(p_103402_, p_103403_, p_103404_, p_103405_);
    }

    public void renderCloak(PoseStack p_103412_, VertexConsumer p_103413_, int p_103414_, int p_103415_) {
        this.cloak.render(p_103412_, p_103413_, p_103414_, p_103415_);
    }

    @Override
    public void setupAnim(T p_103395_, float p_103396_, float p_103397_, float p_103398_, float p_103399_, float p_103400_) {
        super.setupAnim(p_103395_, p_103396_, p_103397_, p_103398_, p_103399_, p_103400_);
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
        if (((LivingEntity)p_103395_).getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            if (((Entity)p_103395_).isCrouching()) {
                this.cloak.z = 1.4f;
                this.cloak.y = 1.85f;
            } else {
                this.cloak.z = 0.0f;
                this.cloak.y = 0.0f;
            }
        } else if (((Entity)p_103395_).isCrouching()) {
            this.cloak.z = 0.3f;
            this.cloak.y = 0.8f;
        } else {
            this.cloak.z = -1.1f;
            this.cloak.y = -0.85f;
        }
    }

    @Override
    public void setAllVisible(boolean p_103419_) {
        super.setAllVisible(p_103419_);
        this.leftSleeve.visible = p_103419_;
        this.rightSleeve.visible = p_103419_;
        this.leftPants.visible = p_103419_;
        this.rightPants.visible = p_103419_;
        this.jacket.visible = p_103419_;
        this.cloak.visible = p_103419_;
        this.ear.visible = p_103419_;
    }

    @Override
    public void translateToHand(HumanoidArm p_103392_, PoseStack p_103393_) {
        ModelPart $$2 = this.getArm(p_103392_);
        if (this.slim) {
            float $$3 = 0.5f * (float)(p_103392_ == HumanoidArm.RIGHT ? 1 : -1);
            $$2.x += $$3;
            $$2.translateAndRotate(p_103393_);
            $$2.x -= $$3;
        } else {
            $$2.translateAndRotate(p_103393_);
        }
    }

    public ModelPart getRandomModelPart(RandomSource p_233439_) {
        return this.parts.get(p_233439_.nextInt(this.parts.size()));
    }
}

